// Prevent "more" messages from appearing
set more off
// Control line length
set linesize 150

// Define working directory for HW data -- replace my example below in quotes
cd "C:\Dropbox\25_PSQF7375_AdvLong\PSQF7375_AdvLong_Example5a"

// Import Example5a stacked data from excel in sheet "Data"
clear // clear memory in case a dataset is already open
import excel "AdvLong_Example5a.xlsx", firstrow case(preserve) clear sheet("Data")


///////// BEGIN MULTILEVEL MODELS FOR EXAMPLE 5A STACKED DATA /////////

// Open external file to save results to
log using AdvLong_Example5a_STATA_Output.log, replace  

display "Step 0: Empty Models for Continu-ish Mood and Symptoms"
mixed symptoms ,  || PersonID: , mle nolog
estat icc

mixed mood2 ,  || PersonID: , mle nolog
estat icc

display "Step 0: Empty Models for Binary Stressors"
display "Using logit link and 15 quadrature points to match Mplus"
melogit stressor ,  || PersonID: , intpoints(15) nolog
estat icc


display "Step 1a: X Stressors Predicting Symptoms Y in Univ MLM"
mixed symptoms c.women c.age80 c.stressor c.PMstress40 ///
               c.women#c.age80,  || PersonID: , mle nolog 
lincom c.stressor*1 + c.PMstress40*1 // BP X to Y Effect


display "Step 2a-ish: M Mood Predicting Symptoms Y in Univ MLM"
mixed symptoms c.women c.age80 c.mood2 c.PMmood2  ///
               c.women#c.age80,  || PersonID: , mle nolog 
lincom c.mood2*1 + c.PMmood2*1 // BP M to Y Effect


// Based on Example 42g in the SEM manual, this should have worked but it didn't
//display "Step 2a-ish: M Mood Predicting Symptoms Y in Multiv MLM"
//gsem (symptoms <- mood2 M1[PersonID]) (symptoms <- mood2 M2[PersonID]),
//      cov(M1[PersonID]*M2[PersonID]@0)

       
// Close external file of saved results
log close  




       
       



